//===============================================================================================
// Methods to support the parsing of an XML document
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

gXMLParser = null;

//-----------------------------------------------------------------------------------------------
function getXMLParser()
	// Returns an existing instance of an xml parser or creates a new one
{
	if( !gXMLParser )
	{
		gXMLParser = newXMLParser();
		if( !gXMLParser ) return;		 
	}

	return gXMLParser;
}

//-----------------------------------------------------------------------------------------------
function newXMLParser()
	// Create a new instance of a parser
{
	var xmlParser = null;
	
	try
	{
		// Try an oldest version for support on IE 5.5 and Windows 98/95
		xmlParser = new ActiveXObject("Msxml.DOMDocument");
	}
	catch(e)
	{
		debugMsg( "Failed to create Msxml.DOMDocument object: " + e, true );
		return null;
	}

	try
	{
		xmlParser.async = false;
		xmlParser.resolveExternals = false;
	}
	catch(e)
	{
		debugMsg( "Failed to initialize Msxml2.DOMDocument object: " + e, true );
		return null;
	}
	
	return xmlParser;
}

//-----------------------------------------------------------------------------------------------
function loadXml( xmlParser, filename )
	// Loads the specified XML document.
	// Returns true on success.
{
	if( !xmlParser || !filename ) return false;
	
	xmlParser.load( filename );
	
	if( xmlParser.parseError.errorCode !=0 )
	{
		if( gbDebug )
		{
			var msg = "### Error parsing " + filename;
			msg += "\n\nReason: " + xmlParser.parseError.reason;
			msg += "\nline:" + xmlParser.parseError.line;
			
			if( window.debugMsg ) debugMsg( msg, true );
			else if( parent.debugMsg ) parent.debugMsg( msg, true );
		}	
		return false;
	}
	
	return true;
}
